unit EditorCTRL;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ImgList, ComCtrls, StdCtrls, ExtCtrls, ExtDlgs,
  JPEG,
  MainData, Present35, PresentEditor35, NewPresentDialog, AboutMain;

type
  TFormTreeSlideEditor = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    MM2Exit: TMenuItem;
    MM2New: TMenuItem;
    MM2Load: TMenuItem;
    MM2Save: TMenuItem;
    ImageList1: TImageList;
    Image1: TImage;
    N3: TMenuItem;
    N4: TMenuItem;
    N7: TMenuItem;
    StatusBar1: TStatusBar;
    Splitter1: TSplitter;
    TreeView1: TTreeView;
    N5: TMenuItem;
    MMAddMainImg: TMenuItem;
    MMAddImg: TMenuItem;
    MMAddVideo: TMenuItem;
    MMAddDocum: TMenuItem;
    N13: TMenuItem;
    MMDeleteSelect: TMenuItem;
    procedure MM2ExitClick(Sender: TObject);
    procedure MM2NewClick(Sender: TObject);
    procedure MM2LoadClick(Sender: TObject);
    procedure MM2SaveClick(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Panel2Resize(Sender: TObject);
    procedure MMAddMainImgClick(Sender: TObject);
    procedure MMAddImgClick(Sender: TObject);
    procedure MMDeleteSelectClick(Sender: TObject);
    procedure MMAddVideoClick(Sender: TObject);
    procedure MMAddDocumClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormTreeSlideEditor: TFormTreeSlideEditor;

implementation

{$R *.dfm}

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

// =========================================================================
//      
// =========================================================================

var PresentEditor : TPresentationEditor;

// =========================================================================
//   
// =========================================================================
// -------------------------------------------------------------------------
// 27.10.2016
// 
procedure TFormTreeSlideEditor.FormCreate(Sender: TObject);
begin
   PresentEditor := TPresentationEditor.Create(Image1,TreeView1,StatusBar1);
end;
// -------------------------------------------------------------------------
// 27.10.2016
// 
procedure TFormTreeSlideEditor.FormDestroy(Sender: TObject);
begin
   if Assigned(PresentEditor) then PresentEditor.Free;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//  
procedure TFormTreeSlideEditor.MM2LoadClick(Sender: TObject);
begin
    if not Assigned(PresentEditor) then Exit;
    Image1.Width  := Panel2.Width  - 4;
    Image1.Height := Panel2.Height - 4;
    //  
    PresentEditor.LoadPresentation(ApplicationDir);
end;
// -------------------------------------------------------------------------
// 27.10.2016
// Resize -    
procedure TFormTreeSlideEditor.Panel2Resize(Sender: TObject);
begin
  if not Assigned(PresentEditor) then Exit;
  if PresentEditor.ShowOK and (PresentEditor.ShowFileName <> '')
  then begin
     Image1.Width  := Panel2.Width  - 4;
     Image1.Height := Panel2.Height - 4;
     // --------------------------------------
     //    
     PresentEditor.ReShowCurrentImage();
     // --------------------------------------
  end;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//     MainImage
procedure TFormTreeSlideEditor.MMAddMainImgClick(Sender: TObject);
begin
   if not Assigned(PresentEditor) then Exit;
   PresentEditor.AddMainImageDialog();
end;
// -------------------------------------------------------------------------
// 27.10.2016
//     Image
procedure TFormTreeSlideEditor.MMAddImgClick(Sender: TObject);
begin
   if not Assigned(PresentEditor) then Exit;
   PresentEditor.AddImageDialog();
end;
// -------------------------------------------------------------------------
// 27.10.2016
//     *.*   Video  Docum
procedure TFormTreeSlideEditor.MMAddVideoClick(Sender: TObject);
begin
  if not Assigned(PresentEditor) then Exit;
  PresentEditor.AddFileDialog();
end;
// -------------------------------------------------------------------------
// 27.10.2016
//     *.*   Video  Docum
procedure TFormTreeSlideEditor.MMAddDocumClick(Sender: TObject);
begin
  if not Assigned(PresentEditor) then Exit;
  PresentEditor.AddFileDialog();
end;
// -------------------------------------------------------------------------
// 27.10.2016
//   
procedure TFormTreeSlideEditor.MMDeleteSelectClick(Sender: TObject);
begin
   if not Assigned(PresentEditor) then Exit;
   PresentEditor.DeleteSelectFile();
end;
// -------------------------------------------------------------------------
// 30.10.2016
//   
procedure TFormTreeSlideEditor.MM2SaveClick(Sender: TObject);
begin
   if not Assigned(PresentEditor) then Exit;
   //   
   PresentEditor.ReSavePresentation();
end;
// -------------------------------------------------------------------------
//     
// 30.10.2016
procedure TFormTreeSlideEditor.MM2NewClick(Sender: TObject);
begin
  if not Assigned(PresentEditor) then Exit;
  if not Assigned(OKBottomDlg) then Exit;
  PresentEditor.BuildSlideSizeBox(OKBottomDlg.cbBoxSlideSize);
  //     
  if OKBottomDlg.ShowModal = mrOk
  then begin
      PresentEditor.SlideSizeIndx := OKBottomDlg.cbBoxSlideSize.ItemIndex;
      PresentEditor.NewPresentation(ApplicationDir,PresentationName);
  end;
end;

// -------------------------------------------------------------------------
//  
procedure TFormTreeSlideEditor.MM2ExitClick(Sender: TObject);
begin
 Close;
end;

// -------------------------------------------------------------------------
procedure TFormTreeSlideEditor.N2Click(Sender: TObject);
begin
  FormAbout.ShowModal;
end;

// -------------------------------------------------------------------------
// -------------------------------------------------------------------------

end.



